/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef _evk_lib_h_
#define _evk_lib_h_

#include <dtvrecdd/ev_common.h>
#include <dtvrecdd/devices_major.h>





#ifdef __KERNEL__

EV_ERR EVK_create_flag(EV_ID flagID);
EV_ERR EVK_create_flag64(EV_ID flagID);
EV_ERR EVK_create_queue(EV_ID queueID,
			UINT8 length,
			UINT16 max_bytes,
			EV_Message_Queue_Type type);

EV_ERR EVK_create_flag_auto_id(EV_ID *flagID);
EV_ERR EVK_create_flag64_auto_id(EV_ID *flagID);
EV_ERR EVK_create_queue_auto_id(EV_ID *queueID,
				UINT8 length,
				UINT16 max_bytes,
				EV_Message_Queue_Type type);

EV_ERR EVK_destroy_flag(EV_ID flagID);
EV_ERR EVK_destroy_queue(EV_ID queueID);


EV_ERR EVK_set_flag(EV_ID flagID, UINT32 bits);
EV_ERR EVK_set_flag64(EV_ID flagID, UINT64 bits);
EV_ERR EVK_send_message(EV_ID queueID, UINT16 bytes, const void *message,
			UINT32 senderInfo);


EV_ERR EVK_get_flag(EV_ID flagID, EV_Flag *flag);
EV_ERR EVK_wait_flag(EV_ID flagID, EV_Flag *flag);
EV_ERR EVK_peek_flag(EV_ID flagID, EV_Flag *flag);
EV_ERR EVK_get_flag64(EV_ID flagID, EV_Flag64 *flag);
EV_ERR EVK_wait_flag64(EV_ID flagID, EV_Flag64 *flag);
EV_ERR EVK_peek_flag64(EV_ID flagID, EV_Flag64 *flag);

EV_ERR EVK_get_message(EV_ID queueID, EV_Message *message);
EV_ERR EVK_wait_message(EV_ID queueID, EV_Message *message);
EV_ERR EVK_peek_message(EV_ID queueID, EV_Message *message);

EV_ERR EVK_find_message_by_sender(EV_ID queueID, UINT32 senderInfo,
				 EV_Message *message);
EV_ERR EVK_find_message_by_content(EV_ID queueID, UINT16 length,
				  const void *compare_bytes,
				  EV_Message *message);
#endif





#define EVK_NAME "evk"
#define EVK_DEV_NAME "/dev/dtvrec/evk"

enum {
  EVK_IOC_CREATE_FLAG = 0,
  EVK_IOC_CREATE_FLAG64,
  EVK_IOC_CREATE_MESSAGE_QUEUE,
  EVK_IOC_ALLOC_FLAG_ID,
  EVK_IOC_ALLOC_FLAG64_ID,
  EVK_IOC_ALLOC_QUEUE_ID,
  EVK_IOC_DESTROY_QUEUE,
  EVK_IOC_STORE_FLAG,
  EVK_IOC_STORE_FLAG64,
  EVK_IOC_STORE_MESSAGE,
  EVK_IOC_SET_POLL,
  EVK_IOC_GET_EVENT,
  EVK_IOC_PEEK_EVENT,
  EVK_IOC_WAIT_EVENT,
  EVK_IOC_GET_NEXT_EVENT,
  EVK_IOC_PEEK_NEXT_EVENT,
  EVK_IOC_DEBUG_LIST,
};

typedef struct {
  EV_ID queueID;
  UINT32 max_bytes;
  UINT8 length;
  EV_Message_Queue_Type type;
} EVK_Message_Queue_Request;

typedef struct {
  INT32 num;
  EV_ID ids[EV_MAX_IDS_IN_PROCESS];
  EV_Event ev;
} EVK_Next_Event_Query;



#endif 
